// CSkipDict.cp
// CSkipDict.h
// ----------------------------------------------------------------------------------
// A Dictionary of words to skip.
//
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original
//		Clark Goble			08/14/94
//			Checked it over and made a few modifications as part of the
//			C++ conversion.
//		Clark Goble			01/29/95
//			Fixed a bug that could cause the skip dictionary to return true
//			words.
// ----------------------------------------------------------------------------------



#include "CSkpDct.h"
#include "UError.h"

#ifdef TEST
#include <stdio.h>
#include <stdlib.h>
#endif

#include <string.h>

// ----------------------------------------------------------------------------------
// Add	- Add a word to the dictionary
// ----------------------------------------------------------------------------------


short 
CSkipDict::Add(char *Word)
{
   if(Usable) 
   {
      SkipFilter->Insert(Word,strlen(Word)); 
      NumWords++;
      return OK;
   }
   ErrorFunc(eUnusableDict, SET);
   return eUnusableDict;
} // Add

short 
CSkipDict::Check(char *Word)
{
	if (Usable) 
	{
     	if ( SkipFilter->Test( Word, strlen(Word) ) == FOUND) 
     		return FOUND;
    	 return NOTFOUND;
	}
   ErrorFunc(eUnusableDict, SET);
   return eUnusableDict;
}

CSkipDict::CSkipDict(long NumBuffers, FioParam * theFile)
	: CDict(NumBuffers, theFile)
{
	SkipFilter = (UBloom *) new UBloom(NumBuffers, 18, By_Key);
   
	if  ( (ErrorFunc(0, GET)< eNo_Err) || (SkipFilter == NULL))
		Usable = FALSE;
	else
   		Usable = TRUE;
   		
	// error handling already in UBloom
	NumWords  = 0;
	MaxWords  = 0;
}

CSkipDict::~CSkipDict()
{
   if ( SkipFilter != NULL) 
   		delete SkipFilter;
}

